clear
set more off
program drop _all
postutil clear
cd "C:\Users\Andrew\My publications\Indonesian Top Incomes\"

use year share1 share01 share001 using shares-ext.dta
sort year
merge year using shares_1982_2004, keep(sharew1 sharew01 sharew001) update
drop _merge 
sort year
merge year using shares-ext-1989, keep(share1 share01 share001) update
drop _merge
tsset year
tsfill
sort year
merge year using topmarginaltaxrate, nokeep
drop _merge
gen aftertaxshare=100-topmarginaltaxrate
gen ats1=100-rate05
gen ats01=100-rate005
sort year
merge year using dutch_top_incomes,keep(netherlands1) nokeep
drop _merge
sort year
merge year using gdp_per_capita, nokeep
drop _merge
tsset year
for any gdp aftertaxshare netherlands1: replace X=l.X if X==.
* To get elasticities, log both sides
*for var share* aftertaxshare: replace X=ln(X)
replace gdp=ln(gdp)
for any 1 01: gen sharepooledX=shareX if year<1960 \ replace sharepooledX=sharewX if year>1960
newey share1 aftertaxshare if year<1960,lag(8) force 
outreg using results.doc, coefastr nocons bracket 3aster replace bdec(3) se ct("IGNORE")
*for any 1 01 : newey shareX aftertaxshare if year<1960,lag(8) force \ outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("SX - 1920-39") \ newey shareX aftertaxshare year if year<1960,lag(8) force \ outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("SX - 1920-39")
*for any 1 01 : newey sharewX aftertaxshare if year>1960,lag(8) force \ outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("SX - 1982-2004") \ newey sharewX aftertaxshare year if year>1960,lag(8) force \ outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("SX - 1982-2004")
for any 1 01 : ivreg2 shareX atsX if year<1960,bw(9) kernel(bartlett) robust small \ outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("SX - 1920-39") \ ivreg2 shareX atsX year if year<1960,bw(9) kernel(bartlett) robust small \ outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("SX - 1920-39")
for any 1 01 : ivreg2 sharewX atsX if year>1960,bw(9) kernel(bartlett) robust small \ outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("SX - 1982-2004") \ ivreg2 sharewX atsX year if year>1960,bw(9) kernel(bartlett) robust small \ outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("SX - 1982-2004")
for any 1 01 : ivreg2 sharepooledX atsX ,bw(9) kernel(bartlett) robust small \ outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("SX - 1920-2004") \ ivreg2 sharepooledX atsX year ,bw(9) kernel(bartlett) robust small \ outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("SX - 1920-2004")

for any 1 01 : ivreg2 shareX (atsX=aftertaxshare) if year<1960,bw(9) kernel(bartlett) robust small first \ outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("SX - 1920-39") \ ivreg2 shareX (atsX=aftertaxshare) year if year<1960,bw(9) kernel(bartlett) robust small first  \ outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("SX - 1920-39")
for any 1 01 : ivreg2 sharewX (atsX=aftertaxshare) if year>1960,bw(9) kernel(bartlett) robust small first \ outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("SX - 1982-2004") \ ivreg2 sharewX (atsX=aftertaxshare) year if year>1960,bw(9) kernel(bartlett) robust small first  \ outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("SX - 1982-2004")
for any 1 01 : ivreg2 sharepooledX (atsX=aftertaxshare) ,bw(9) kernel(bartlett) robust small first \ outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("SX - 1920-2004") \ ivreg2 sharepooledX (atsX=aftertaxshare) year ,bw(9) kernel(bartlett) robust small first  \ outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("SX - 1920-2004")


* How closely do Indonesian top incomes track those in other countries?
* We adjust to calendar year basis
* We use China estimates on a household basis
clear
set more off
cd "C:\Users\Andrew\My publications\Indonesian Top Incomes\"
use year share1 share01 share001 using shares-ext.dta
sort year
merge year using shares_1982_2004, keep(sharew1 sharew01 sharew001) update
drop _merge 
sort year
merge year using shares-ext-1989, keep(share1 share01 share001) update
drop _merge
for any 1 01 001: replace shareX=. if year>1960 \ replace shareX=sharewX if year>1960 \ drop sharewX
sort year
merge year using topinc_leigh_2007_calyr, nokeep
drop _merge
for any india china argentina finland: sort year \ merge year using X_top_incomes,nokeep \ drop _merge
keep argentina1 australia1 canada1 china1 finland1 france1 germany1 india1 ireland1 japan1 netherlands1 nz1 spain1 sweden1 switzerland1 uk1 us1 share1 year
* argentina01 australia01 canada01 china01 finland01 france01 germany01 india01 ireland01 japan01 netherlands01 nz01 spain01 sweden01 switzerland01 uk01 us01
for any 1 01 001: gen otherX=.
tsset year
* replace other1=X1 \ reg share1 other1,r \ outreg using results.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Y") ;
gen str country=""
gen diff=.
gen diff_p=.
gen n=.
gen minyear=.
gen maxyear=.
gen rho=.

#delimit ;
for any argentina australia canada china finland france germany india ireland japan netherlands nz spain sweden switzerland uk us
\ any Argentina Australia Canada "China (Urban only)" Finland France Germany India Ireland Japan Netherlands "New Zealand" Spain Sweden Switzerland "United Kingdom" "United States" 
\ Z in num 1(2)33: 
replace country="Y" if _n==Z \
ttest share1==X1 \
replace diff=r(mu_2)-r(mu_1) if _n==Z \
replace diff=r(se) if _n==Z+1 \
replace diff_p=r(p) if _n==Z \
replace n=r(N_1) if _n==Z \
egen temp1=min(year) if share1~=. & X1~=. \
egen temp2=min(temp1) \ 
replace minyear=temp2 if _n==Z \
egen temp3=max(year) if share1~=. & X1~=. \
egen temp4=max(temp3) \ 
replace maxyear=temp4 if _n==Z \
drop temp* \
corr share1 X1 \
replace rho=r(rho) if _n==Z;
#delimit cr
replace country="New Zealand" if country=="New 23ealand"

* Significance of correlations
for any argentina australia canada china finland france germany india ireland japan netherlands nz spain sweden switzerland uk us: pwcorr share1 X1, sig

replace country="Mean" if _n==35
egen temp1=mean(diff) if _n/2~=int(_n/2)
egen temp2=max(temp1)
replace diff=temp2 if country=="Mean"
egen temp3=mean(rho) if _n/2~=int(_n/2)
egen temp4=max(temp3)
replace rho=temp4 if country=="Mean"

keep if _n<=35
gen str range=string(minyear)+"-"+string(maxyear) if country~=""
for var diff diff_p rho: format X %9.3f
tostring diff , force replace format(%9.3f)
replace diff="["+diff+"]" if country==""
keep country diff diff_p rho n range
order country diff diff_p rho n range

browse


*****************************************************
* How correlated are the tax and survey estimates, 
* looking separately at P99.90-99.95 and P99.95-P100?
*****************************************************
cd "C:\Users\Andrew\My publications\Indonesian Top Incomes\"
use sharew01 sharew005 year using shares_1982_2004, clear
sort year
merge year using shares-ext-1989, keep(share01 share005) update

gen top05_tax=share005
gen next05_tax=share01-share005

gen top05_survey=sharew005
gen next05_survey=sharew01-sharew005

pwcorr top05_tax top05_survey,obs
pwcorr next05_tax next05_survey,obs

pwcorr top05_tax next05_tax,obs
pwcorr top05_survey next05_survey,obs

sort year
tw line top05_tax top05_survey year, name(top, replace)
tw line next05_tax next05_survey year,name(next, replace)
gr combine top next

***************************************************
* Comparing our estimates with the high benchmark (US 2000) 
* and low benchmark (Sweden 1988)
***************************************************
set more off
cd "C:\Users\Andrew\My publications\Indonesian Top Incomes\"
use topinc_leigh_2007_calyr, clear
keep year sweden* us*
egen temp1=min(sweden10) if year>1950
gen temp2=1 if sweden10==temp1 & year>1950
for var sweden*: replace X=. if temp2~=1 \ egen temp3=mode(X) \ replace X=temp3 \ drop temp3
renpfix sweden sw
drop temp*
egen temp1=max(us10) if year>1950
gen temp2=1 if us10==temp1 & year>1950 & year~=2004
gen us005=us01*.7
for var us*: replace X=. if temp2~=1 \ egen temp3=mode(X) \ replace X=temp3 \ drop temp3
drop temp*
sort year
merge year using shares-ext.dta,keep(share*)
drop _merge
sort year
merge year using shares_1982_2004, keep(sharew*) update
drop _merge 
sort year
merge year using shares-ext-1989, keep(share*) update
drop _merge

* First, we look at the survey-derived estimates (using prop share differences)
*for any sharew: gen p90_95=X10-X5 \ gen p99_95=X5-X1 \ gen p995_99=X1-X05 \ gen p999_995=X05-X01 \ gen p9995_999=X01-X005 \ gen p9999_9995=X005-X001 \ gen p9999_100=X001
*for any us sw: gen Xp90_95=X10-X5 \ gen Xp99_95=X5-X1 \ gen Xp995_99=X1-X05 \ gen Xp999_995=X05-X01 \ gen Xp9995_999=X01-X005 \ gen Xp9999_9995=X005-X001 \ gen Xp9999_100=X001
for any sharew: gen p90_95=(X10-X5)/5 \ gen p99_95=(X5-X1)/4 \ gen p995_99=(X1-X05)/.5 \ gen p999_995=(X05-X01)/.4 \ gen p9995_999=(X01-X005)/.05 \ gen p9999_9995=(X005-X001)/.04 \ gen p9999_100=X001/.01
for any us sw: gen Xp90_95=(X10-X5)/5 \ gen Xp99_95=(X5-X1)/4 \ gen Xp995_99=(X1-X05)/.5 \ gen Xp999_995=(X05-X01)/.4 \ gen Xp9995_999=(X01-X005)/.05 \ gen Xp9999_9995=(X005-X001)/.04 \ gen Xp9999_100=X001/.01
for any 90_95 99_95 995_99 999_995 9995_999 9999_9995 9999_100: gen lowX=0 \ gen highX=0 \  replace lowX=1 if pX<swpX & pX~=. \ replace highX=1 if pX>uspX & pX~=. 
for any 90_95 99_95 995_99 999_995 9995_999 9999_9995 9999_100: list year swpX pX if lowX==1 \ list year uspX pX if highX==1 
for any 90_95 99_95 995_99 999_995 9995_999 9999_9995 9999_100: sum swpX uspX

* Now we analyse the tax-derived estimates (using prop share differences)
drop p90_95-p9999_100 low* high*
*for any share: gen p90_95=X10-X5 \ gen p99_95=X5-X1 \ gen p995_99=X1-X05 \ gen p999_995=X05-X01 \ gen p9995_999=X01-X005 \ gen p9999_9995=X005-X001 \ gen p9999_100=X001
for any share: gen p90_95=(X10-X5)/5 \ gen p99_95=(X5-X1)/4 \ gen p995_99=(X1-X05)/.5 \ gen p999_995=(X05-X01)/.4 \ gen p9995_999=(X01-X005)/.05 \ gen p9999_9995=(X005-X001)/.04 \ gen p9999_100=X001/.01
for any 90_95 99_95 995_99 999_995 9995_999 9999_9995 9999_100: gen lowX=0 \ gen highX=0 \  replace lowX=1 if pX<swpX & pX~=. \ replace highX=1 if pX>uspX & pX~=. 
for any 10 5 1 05 01 005 001: gen lowX=0 \ gen highX=0 \  replace lowX=1 if shareX<swX & shareX~=. \ replace highX=1 if shareX>usX & shareX~=. 
for any 90_95 99_95 995_99 999_995 9995_999 9999_9995 9999_100: list year swpX pX if lowX==1 
for any 90_95 99_95 995_99 999_995 9995_999 9999_9995 9999_100: list year uspX pX if highX==1 
for any 10 5 1 05 01 005 001: list year swX shareX if lowX==1 
for any 10 5 1 05 01 005 001: list year usX shareX if highX==1 

* Now we analyse the survey-derived estimates (using ratios)
drop p90_95-p9999_100 usp* swp* low* high*
for any sharew: gen p90_95=X5/X10 \ gen p99_95=X1/X5 \ gen p995_99=X05/X1 \ gen p999_995=X01/X05 \ gen p9995_999=X005/X01 \ gen p9999_9995=X001/X005 \ gen p9999_100=X001
for any us sw: gen Xp90_95=X5/X10 \ gen Xp99_95=X1/X5 \ gen Xp995_99=X05/X1 \ gen Xp999_995=X01/X05 \ gen Xp9995_999=X005/X01 \ gen Xp9999_9995=X001/X005 \ gen Xp9999_100=X001
for any 90_95 99_95 995_99 999_995 9995_999 9999_9995 9999_100: gen lowX=0 \ gen highX=0 \  replace lowX=1 if pX<swpX & pX~=. \ replace highX=1 if pX>uspX & pX~=. 
for any 90_95 99_95 995_99 999_995 9995_999 9999_9995 9999_100: list year swpX pX if lowX==1 
for any 90_95 99_95 995_99 999_995 9995_999 9999_9995 9999_100: list year uspX pX if highX==1 

* Now we analyse the tax-derived estimates (using ratios)
drop p90_95-p9999_100 low* high*
for any share: gen p90_95=X5/X10 \ gen p99_95=X1/X5 \ gen p995_99=X05/X1 \ gen p999_995=X01/X05 \ gen p9995_999=X005/X01 \ gen p9999_9995=X001/X005 \ gen p9999_100=X001
for any 90_95 99_95 995_99 999_995 9995_999 9999_9995 9999_100: gen lowX=0 \ gen highX=0 \  replace lowX=1 if pX<swpX & pX~=. \ replace highX=1 if pX>uspX & pX~=. 
for any 90_95 99_95 995_99 999_995 9995_999 9999_9995 9999_100: list year swpX pX if lowX==1 
for any 90_95 99_95 995_99 999_995 9995_999 9999_9995 9999_100: list year uspX pX if highX==1 

*****************************
* Comparing Indonesian inequality with other countries, using the WIID
*****************************
use "C:\Users\Andrew\My publications\Indonesian Top Incomes\wiid2c.dta", clear
gen order=_n
keep if country=="Indonesia" | country=="India" | country=="Japan" | country=="United States" | country=="Argentina"
gen yearnum=real(year)
drop year
ren yearnum year
gen year5=(int(year/5)*5)+2
for num 1/4: bysort country year5: egen tempX=mean(gini) if quality==X \ bysort country year5: egen gini_qX=mode(tempX)
drop temp*
gen gini5=gini_q1
for num 2/4: replace gini5=gini_qX if gini5==.
egen tag=tag(country year5) if gini5~=.
keep if tag
egen countryno=group(country)
tsset countryno year5
tsfill
replace country="US" if country=="United States"
for any Indonesia India Japan US Argentina: gen X=gini5 if country=="X"
sort year5
tw line Indonesia India Japan US Argentina year5 if year5>1960 & year5<2005,yti("Gini") ti("Highest quality estimate of inequality") subti("Source: World Income Inequality Database")

